from pydantic import BaseModel
from datetime import datetime, date
from typing import List, Optional
from datetime import datetime
from pydantic import BaseModel, Field
from ..basemodel import CommonBase
from ..common import InvoiceStatus, InvoiceType  # import the new enum(s)


class SubscriptionTypeBase(BaseModel):
    name: str
    target: str
    features: List[str]
    price: float
    responses_limit: int
    status: bool = True  # To enable or disable a subscription type

class SubscriptionTypeCreate(SubscriptionTypeBase):
    pass

class SubscriptionType(SubscriptionTypeBase):
    subscription_type_id: int

class SubscriptionBase(BaseModel):
    account_id: str
    user_id: str
    subscription_type_id: int
    subscription_agents_count: int  # Total number of agents subscription
    stripe_subscription_id: Optional[str] =""
    active_agents_count: int  # Active number of agents    
    peragent_cost: float  # New field for the total cost of the subscription
    total_cost: float  # New field for the total cost of the subscription
    start_date: Optional[datetime] = None
    renew_start_date: Optional[datetime] = None #This date will be updated when they renew
    renew_end_date: Optional[datetime] = None #This will be updated when they renew
    status: str = "new" # Status can be 'active', 'cancelled', etc.
    discount: Optional[int] = 0 #percentage of discount applied
    discount_reason: Optional[str] = ""

class SubscriptionCreate(SubscriptionBase):
    pass

class Subscription(SubscriptionBase):
    subscription_id: str

class SubscriptionUpdate(BaseModel):
    subscription_id: str
    stripe_subscription_id: Optional[str]
    subscription_type_id: int
    subscription_agents_count: int
    peragent_cost: float
    total_cost: float

class SubscriptionLog(SubscriptionBase):
    subscription_id: str
    updated_date: datetime
    updated_user_id: str

class PaymentBase(BaseModel):
    subscription_id: str
    stripe_subscription_id: str
    account_id: str
    amount: float
    due_date: datetime
    status: str

class PaymentCreate(PaymentBase):
    pass

class Payment(PaymentBase):
    payment_id: str

class PaymentUpdate(BaseModel):
    status: str  # To update the payment status (e.g., 'paid', 'unpaid', 'cancelled')

class SaaSInvoices(BaseModel):
    invoice_id: str
    subscription_id: str
    amount: float
    status: InvoiceStatus  # Assuming you imported this enum already
    created_at: datetime
    due_date: datetime
